/*******************************************************************************
 * Copyright (c) 2000, 2009 IBM Corporation and others.
 *
 * This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.jdt.internal.ui.refactoring;

import org.eclipse.swt.widgets.Shell;

import org.eclipse.core.runtime.CoreException;

import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;

import org.eclipse.jdt.ui.refactoring.RefactoringSaveHelper;

import org.eclipse.jdt.internal.ui.refactoring.actions.RefactoringStarter;

/**
 * Opens the user interface for a given refactoring.
 */
public class UserInterfaceStarter {

	private RefactoringWizard fWizard;

	/**
	 * Initializes this user interface starter with the given
	 * wizard.
	 *
	 * @param wizard the refactoring wizard to use
	 */
	public void initialize(RefactoringWizard wizard) {
		fWizard= wizard;
	}

	/**
	 * Actually activates the user interface. This default implementation
	 * assumes that the configuration element passed to <code>initialize
	 * </code> has an attribute wizard denoting the wizard class to be
	 * used for the given refactoring.
	 * <p>
	 * Subclasses may override to open a different user interface
	 *
	 * @param refactoring the refactoring for which the user interface
	 *  should be opened
	 * @param parent the parent shell to be used
	 * @param saveMode a save mode from {@link RefactoringSaveHelper}
	 * @return <code>true</code> iff the refactoring was executed,
	 *  <code>false</code> otherwise
	 *
	 * @exception CoreException if the user interface can't be activated
	 */
	public boolean activate(Refactoring refactoring, Shell parent, int saveMode) throws CoreException {
		String title= fWizard.getDefaultPageTitle();
		if (title == null)
			title= ""; //$NON-NLS-1$
		return new RefactoringStarter().activate(fWizard, parent, title, saveMode);
	}
}
